use mle_data.dta, clear

forvalues k = 3 (3) 21 {
global x`k' aedu edu2 edu3 i.reg_res`k' ur`k' er`k' tfr`k' i.inps_anno`k'
}

****************************************************************
*The following dummies indicate the year since the diploma in which the 1st, 2nd, and 3rd kids are born
********************************************************************
*** nascita primo figlio per periodi 13 46 79 1012 1315 1618 1921
gen kid1_13=0
replace kid1_13=1 if (child1_1==1 | child1_2==1 | child1_3==1)   
gen kid1_46=0
replace kid1_46=1 if (child1_4==1 | child1_5==1 | child1_6==1)   
gen kid1_79=0
replace kid1_79=1 if (child1_7==1 | child1_8==1 | child1_9==1)   
gen kid1_1012=0
replace kid1_1012=1 if (child1_10==1 | child1_11==1 | child1_12==1)   
gen kid1_1315=0
replace kid1_1315=1 if (child1_13==1 | child1_14==1 | child1_15==1)   
gen kid1_1618=0
replace kid1_1618=1 if (child1_16==1 | child1_17==1 | child1_18==1)   
gen kid1_1921=0
replace kid1_1921=1 if (child1_19==1 | child1_20==1 | child1_21==1)   
*** nascita secondo figlio per periodi 16 79 1012 1315 1618 1921
gen kid2_16=0
replace kid2_16=1 if (child2_1==1 | child2_2==1 | child2_3==1 | child2_4==1 | child2_5==1 | child2_6==1)   
gen kid2_79=0
replace kid2_79=1 if (child2_7==1 | child2_8==1 | child2_9==1)   
gen kid2_1012=0
replace kid2_1012=1 if (child2_10==1 | child2_11==1 | child2_12==1)   
gen kid2_1315=0
replace kid2_1315=1 if (child2_13==1 | child2_14==1 | child2_15==1)   
gen kid2_1618=0
replace kid2_1618=1 if (child2_16==1 | child2_17==1 | child2_18==1)   
gen kid2_1921=0
replace kid2_1921=1 if (child2_19==1 | child2_20==1 | child2_21==1)   
*** nascita terzo figlio per periodi 1-12 1315 1618 1921
gen kid3_112=0
replace kid3_112=1 if (child3_1==1 | child3_2==1 | child3_3==1 | child3_4==1 | child3_5==1 | child3_6==1 | child3_7==1 | child3_8==1 | child3_9==1 | child3_10==1 | child3_11==1 | child3_12==1)   
gen kid3_1315=0
replace kid3_1315=1 if (child3_13==1 | child3_14==1 | child3_15==1)   
gen kid3_1618=0
replace kid3_1618=1 if (child3_16==1 | child3_17==1 | child3_18==1 )
gen kid3_1921=0
replace kid3_1921=1 if (child3_19==1 | child3_20==1 | child3_21==1)   

*** new
gen kid3_19=0
replace kid3_19=1 if (child3_1==1 | child3_2==1 | child3_3==1 | child3_4==1 | child3_5==1 | child3_6==1 | child3_7==1 | child3_8==1 | child3_9==1)


*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 21 years after the diploma
global child1_21 child1_1 child1_2 child1_3 child1_4 child1_5 child1_6 child1_7 child1_8 child1_9 child1_10 child1_11 child1_12 child1_13 child1_14 child1_15 child1_16 child1_17 child1_18 child1_19 child1_20 child1_21
global kid1_21 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315 kid1_1618 kid1_1921
global kid2_21 kid2_16 kid2_79 kid2_1012 kid2_1315 kid2_1618 kid2_1921
		*global kid3_21 kid3_19 kid3_1012 kid3_1315 kid3_1618 kid3_1921
global kid3_21 kid3_112 kid3_1315 kid3_1618 kid3_1921
global k2_21 k2_12_21 k2_34_21 k2_56_21 k2_721_21
global k3_21 k3_14_21 k3_521_21

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 18 years after the diploma
global kid1_18 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315 kid1_1618
global kid2_18 kid2_16 kid2_79 kid2_1012 kid2_1315 kid2_1618
	*global kid3_18 kid3_19 kid3_1012 kid3_1315 kid3_1618
global kid3_18 kid3_112 kid3_1315 kid3_1618
global k2_18 k2_12_18 k2_34_18 k2_56_18 k2_721_18
global k3_18 k3_14_18 k3_521_18

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 15 years after the diploma
global kid1_15 kid1_13 kid1_46 kid1_79 kid1_1012 kid1_1315
global kid2_15 kid2_16 kid2_79 kid2_1012 kid2_1315
	* global kid3_15 kid3_19 kid3_1012 kid3_1315
global kid3_15 kid3_112 kid3_1315 
global k2_15 k2_12_15 k2_34_15 k2_56_15 k2_721_15
global k3_15 k3_14_15 k3_521_15

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 12 years after the diploma
global kid1_12 kid1_13 kid1_46 kid1_79 kid1_1012
global kid2_12 kid2_16 kid2_79 kid2_1012
	*global kid3_12 kid3_19 kid3_1012
global kid3_12 kid3_112 
global k2_12 k2_12_12 k2_34_12 k2_56_12 k2_721_12
global k3_12 k3_14_12 k3_521_12

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 9 years after the diploma
global kid1_9 kid1_13 kid1_46 kid1_79
global kid2_9 kid2_16 kid2_79
global kid3_9 kid3_19
global k2_9 k2_12_9 k2_34_9 k2_56_9 k2_721_9
global k3_9 k3_14_9 k3_521_9

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 6 years after the diploma
global kid1_6 kid1_13 kid1_46
global kid2_6 kid2_16
global kid3_6 kid3_19

cap drop kid2_6
gen kid2_6=0
replace kid2_6=1 if num_kids_6==2
gen kid3_6=0
replace kid3_6=1 if num_kids_6==3

*Effect of the timing of births of 1st, 2nd, and 3rd kids on earnings 3 years after the diploma
gen kids_3=0
replace kids_3=1 if num_kids_3==1 | num_kids_3==2


forval i=3 (3) 21{
di "Years from diploma" `i'
latabstat num_kids_`i' lab_ear`i' lab_wag`i' totday`i' totday_pt`i' totday_ft`i' if lab_ear21!=., s(mean sd)
}

forval i=3 (3) 21{
di "Years from diploma" `i'
latabstat num_kids_`i' lab_ear`i' lab_wag`i' totday`i' totday_pt`i' totday_ft`i' if lab_ear21!=., s(mean sd count) format(%3.2f)
}

forval i=3 (3) 21{
gen numfig`i'=num_kids_`i'
replace numfig`i'=2 if numfig`i'>2
label define numfig 2 "2 or 3", modify
label values numfig numfig
di "Years from diploma" `i'
latabstat lab_ear`i' lab_wag`i' totday`i' totday_pt`i' totday_ft`i' , s(mean count) by(numfig`i') format(%3.2f)
cap drop numfig*
}

forval i=3 (3) 21{
latabstat nascita aedu  edu2 edu3 if lab_ear`i'!=., s(mean) format(%3.2f)
}

*GRAPH FOR IMPACT OF 1ST KID
*Heterogenous effect of kids across different timings 
reg lab_ear21 $kid1_21 $kid2_21 $kid3_21 $x21, r
estimates store E21
reg lab_ear18 $kid1_18 $kid2_18 $kid3_18 $x18, r
estimates store E18
reg lab_ear15 $kid1_15 $kid2_15 $kid3_15 $x15, r
estimates store E15
reg lab_ear12 $kid1_12 $kid2_12 $kid3_12 $x12, r
estimates store E12
reg lab_ear9  $kid1_9 $kid2_9 $kid3_9    $x9, r
estimates store E9
reg lab_ear6 $kid1_6 kid2_6 kid3_6   $x6, r
est store E6
reg lab_ear3 kids_3		             $x3, r
est store E3

forvalues k = 3 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,1]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[1,1])
matrix drop A
}
matrix beta_13 = (beta3, beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_13   = (se3, se6, se9, se12, se15, se18, se21)

forvalues k = 6 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,2]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[2,2])
matrix drop A
}
matrix beta_46 = (., beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_46   = (., se6, se9, se12, se15, se18, se21)

forvalues k = 9 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,3]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[3,3])
matrix drop A
}
matrix beta_79 = (., ., beta9, beta12, beta15, beta18, beta21)
matrix se_79   = (., ., se9, se12, se15, se18, se21)


forvalues k = 12 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,4]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[4,4])
matrix drop A
}
matrix beta_1012 = (., ., ., beta12, beta15, beta18, beta21)
matrix se_1012   = (., ., ., se12, se15, se18, se21)

*title("Over time variation of labour earnings after 1st childbirth" "occurring 1-3, 4-6, or 10-12 Years after school completion") 
*** graph
coefplot (matrix(beta_13), se(se_13) label(1st childbearing 0-3 years)  color(black)) (matrix(beta_46), se(se_46) label(1st childbearing 4-6 years) msymbol(triangle) lpattern(shortdash) color(black)) /*
	*/ (matrix(beta_79), se(se_79) label(1st childbearing 7-9 years) msymbol(diamond) lpattern(dash)color(black) ), /*
	*/ xtitle("Years after school completion") ytitle("Variation in yearly labour earnings") /*
	*/ coeflabels(c1 = "3" c2 = "6" c3 = "9" c4 = "12" c5 = "15" c6 = "18" c7 = "21") /*
	*/ vertical recast(connected) /*
	*/ graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) grid(between) /*
	*/ scale(1) yline(0) xline(1.5 2.5 3.5 4.5 5.5 6.5, lstyle(p5) )  
graph export "lab_ear_1.pdf", as(pdf) logo(off) fontface(Times) replace


*GRAPH FOR IMPACT OF 2ND KID
*Heterogenous effect of kids across different timings 
qui reg lab_ear21 $kid2_21 $kid1_21 $kid3_21 $x21, r
estimates store E21
qui reg lab_ear18 $kid2_18 $kid1_18  $kid3_18 $x18, r
estimates store E18
qui reg lab_ear15 $kid2_15 $kid1_15  $kid3_15 $x15, r
estimates store E15
qui reg lab_ear12 $kid2_12 $kid1_12  $kid3_12 $x12, r
estimates store E12
qui reg lab_ear9 $kid2_9 $kid1_9  $kid3_9 $x9, r
estimates store E9
qui reg lab_ear6 kid2_6 $kid1_6 kid3_6   $x6, r
est store E6

forvalues k = 6 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,1]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[1,1])
matrix drop A
}
matrix beta_16 = (beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_16   = (se6, se9, se12, se15, se18, se21)

forvalues k = 9 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,2]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[2,2])
matrix drop A
}
matrix beta_79 = (., beta9, beta12, beta15, beta18, beta21)
matrix se_79   = (., se9 , se12, se15, se18, se21)

forvalues k = 12 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,3]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[3,3])
matrix drop A
}
matrix beta_1012 = (., ., beta12, beta15, beta18, beta21)
matrix se_1012   = (., ., se12, se15, se18, se21)


coefplot (matrix(beta_16), se(se_16) label(2nd childbearing 1-6 years)  color(black)) (matrix(beta_79), se(se_79) label(2nd childbearing 7-9 years) msymbol(triangle) lpattern(shortdash) color(black)) /*
	*/ (matrix(beta_1012), se(se_1012) label(2nd childbearing 10-12 years) msymbol(diamond) lpattern(dash)color(black) ), /*
	*/ xtitle("Years after school completion") ytitle("Variation in yearly labour earnings") /*
	*/ coeflabels(c1 = "6" c2 = "9" c3 = "12" c4 = "15" c5 = "18" c6 = "21") /*
	*/ vertical recast(connected) /*
	*/ graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) grid(between) /*
	*/ scale(1) yline(0) xline(1.5 2.5 3.5 4.5 5.5 6.5, lstyle(p5) )  
graph export "lab_ear_2kid_1.pdf", as(pdf) logo(off) fontface(Times) replace

*************************************
*Using totday# as dependent variable
*************************************
*GRAPH FOR IMPACT OF 1ST KID
*Heterogenous effect of kids across different timings 
reg totday21 $kid1_21 $kid2_21 $kid3_21 $x21, r
estimates store E21
reg totday18 $kid1_18 $kid2_18 $kid3_18 $x18, r
estimates store E18
reg totday15 $kid1_15 $kid2_15 $kid3_15 $x15, r
estimates store E15
reg totday12 $kid1_12 $kid2_12 $kid3_12 $x12, r
estimates store E12
reg totday9  $kid1_9 $kid2_9 $kid3_9    $x9, r
estimates store E9
reg totday6 $kid1_6 kid2_6 kid3_6   $x6, r
est store E6
reg totday3 kids_3		        $x3, r
est store E3

forvalues k = 3 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,1]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[1,1])
matrix drop A
}
matrix beta_13 = (beta3, beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_13   = (se3, se6, se9, se12, se15, se18, se21)

forvalues k = 6 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,2]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[2,2])
matrix drop A
}
matrix beta_46 = (., beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_46   = (., se6, se9, se12, se15, se18, se21)

forvalues k = 9 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,3]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[3,3])
matrix drop A
}
matrix beta_79 = (., ., beta9, beta12, beta15, beta18, beta21)
matrix se_79   = (., ., se9, se12, se15, se18, se21)

forvalues k = 12 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,4]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[4,4])
matrix drop A
}
matrix beta_1012 = (., ., ., beta12, beta15, beta18, beta21)
matrix se_1012   = (., ., ., se12, se15, se18, se21)

coefplot (matrix(beta_13), se(se_13) label(1st childbearing 0-3 years) color(black)) (matrix(beta_46), se(se_46) label(1st childbearing 4-6 years) msymbol(triangle) lpattern(shortdash) color(black)) /*
	*/ (matrix(beta_79), se(se_79) label(1st childbearing 7-9 years) msymbol(diamond) lpattern(dash)color(black) ), /*
	*/ xtitle("Years after school completion") ytitle("Variation of fraction of days at work") /*
	*/ coeflabels(c1 = "3" c2 = "6" c3 = "9" c4 = "12" c5 = "15" c6 = "18" c7 = "21") /*
	*/ vertical recast(connected) /*
	*/ graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) grid(between) /*
	*/ scale(1) yline(0) xline(1.5 2.5 3.5 4.5 5.5 6.5, lstyle(p5) )
graph export "totday_1.pdf", as(pdf) logo(off) fontface(Times) replace

*GRAPH FOR IMPACT OF 2ND KID
*Heterogenous effect of kids across different timings 
qui reg totday21 $kid2_21 $kid1_21 $kid3_21 $x21, r
estimates store E21
qui reg totday18 $kid2_18 $kid1_18  $kid3_18 $x18, r
estimates store E18
qui reg totday15 $kid2_15 $kid1_15  $kid3_15 $x15, r
estimates store E15
qui reg totday12 $kid2_12 $kid1_12  $kid3_12 $x12, r
estimates store E12
qui reg totday9 $kid2_9 $kid1_9  $kid3_9 $x9, r
estimates store E9
qui reg totday6 kid2_6 $kid1_6 kid3_6   $x6, r
est store E6

forvalues k = 6 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,1]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[1,1])
matrix drop A
}
matrix beta_16 = (beta6, beta9, beta12, beta15, beta18, beta21)
matrix se_16   = (se6, se9, se12, se15, se18, se21)

forvalues k = 9 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,2]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[2,2])
matrix drop A
}
matrix beta_79 = (., beta9, beta12, beta15, beta18, beta21)
matrix se_79   = (., se9 , se12, se15, se18, se21)

forvalues k = 12 (3) 21 {
est restore E`k'
matrix A=e(b)
scalar beta`k'=A[1,3]
matrix drop A
matrix A=e(V)
scalar se`k'=sqrt(A[3,3])
matrix drop A
}
matrix beta_1012 = (., ., beta12, beta15, beta18, beta21)
matrix se_1012   = (., ., se12, se15, se18, se21)


coefplot (matrix(beta_16), se(se_16) label(2nd childbearing 1-6 years)  color(black)) (matrix(beta_79), se(se_79) label(2nd childbearing 7-9 years) msymbol(triangle) lpattern(shortdash) color(black)) /*
	*/ (matrix(beta_1012), se(se_1012) label(2nd childbearing 10-12 years) msymbol(diamond) lpattern(dash)color(black) ), /*
	*/ xtitle("Years after school completion") ytitle("Variation of fraction of days at work") /*
	*/ coeflabels(c1 = "6" c2 = "9" c3 = "12" c4 = "15" c5 = "18" c6 = "21") /*
	*/ vertical recast(connected) /*
	*/ graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) plotregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white)) grid(between) /*
	*/ scale(1) yline(0) xline(1.5 2.5 3.5 4.5 5.5 6.5, lstyle(p5) )  
graph export "totday_2kid_1.pdf", as(pdf) logo(off) fontface(Times) replace
